<?php echo form_open(get_uri("leads/save"), array("id" => "lead-form", "class" => "general-form", "role" => "form")); ?>
<div class="modal-body clearfix">
    <div class="container-fluid">
        <?php echo view("leads/lead_form_fields"); ?>
    </div>
</div>

<div class="modal-footer">
    <button type="button" class="btn btn-default" data-bs-dismiss="modal"><span data-feather="x" class="icon-16"></span> <?php echo app_lang('close'); ?></button>
    <button type="submit" class="btn btn-primary"><span data-feather="check-circle" class="icon-16"></span> <?php echo app_lang('save'); ?></button>
</div>
<?php echo form_close(); ?>

<script type="text/javascript">
    $(document).ready(function() {
        var phoneInput = initializeIntlTelInput("#phone");

        $("#lead-form").appForm({
            beforeAjaxSubmit: function(data) {
                $.each(data, function(index, obj) {
                    if (obj.name === "phone" && phoneInput) {
                        data[index].value = phoneInput.getNumber();
                    }
                });
            },
            onSuccess: function(result) {
                if (result.view === "details") {
                    appAlert.success(result.message, {
                        duration: 10000
                    });
                    setTimeout(function() {
                        location.reload();
                    }, 500);
                } else {
                    $("#lead-table").appTable({
                        newData: result.data,
                        dataId: result.id
                    });
                    $("#reload-kanban-button:visible").trigger("click");
                }
            }
        });
        setTimeout(function() {
            $("#company_name").focus();
        }, 200);
    });
</script>